/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.VI;

import com.quantumdata.std.RemoteInstrument;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

public class GenButtonHandler
extends MouseAdapter
implements ActionListener {
    static final int KEY_LEFT_1 = 3;
    static final int KEY_LEFT_2 = 2;
    static final int KEY_LEFT_3 = 1;
    static final int KEY_LEFT_4 = 0;
    static final int KEY_RIGHT_1 = 7;
    static final int KEY_RIGHT_2 = 6;
    static final int KEY_RIGHT_3 = 5;
    static final int KEY_RIGHT_4 = 4;
    static final int KEY_TOP_1 = 9;
    static final int KEY_TOP_2 = 11;
    static final int KEY_TOP_3 = 13;
    static final int KEY_BOT_1 = 8;
    static final int KEY_BOT_2 = 10;
    static final int KEY_BOT_3 = 12;
    static final int KEY_BOT_4 = 14;
    static final int KEY_UP_ARROW = 15;
    static final int KEY_DOWN_ARROW = 16;
    static final int KEY_REPEAT = 128;
    static final int KEY_HELD = 256;
    static final int KEY_RELEASE = 512;
    static final int KEY_DEVICE = 1024;
    static final int KEY_USER = 1025;
    static final int KEY_SPOT = 1026;
    static final int KEY_BROWSE = 9;
    private RemoteInstrument m_instrument;
    private int m_keyId;
    private boolean m_mousePressed = false;
    private Timer m_timer;
    private int m_timeCnt;

    public GenButtonHandler(RemoteInstrument remoteInstrument, int n) {
        this.m_instrument = remoteInstrument;
        this.m_keyId = n;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenButtonHandler.this.m_timeCnt++;
                if (GenButtonHandler.this.m_timeCnt < 5) {
                    return;
                }
                if (GenButtonHandler.this.m_timeCnt == 10) {
                    GenButtonHandler.this.SendKey(GenButtonHandler.this.m_keyId | 0x100);
                } else {
                    GenButtonHandler.this.SendKey(GenButtonHandler.this.m_keyId | 0x80);
                }
            }
        };
        this.m_timer = new Timer(100, actionListener);
        this.m_timer.setRepeats(true);
        this.m_timer.setCoalesce(true);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_mousePressed = true;
        this.m_timeCnt = 0;
        this.m_timer.start();
        this.SendKey(this.m_keyId);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_timer.stop();
        this.SendKey(this.m_keyId | 0x200);
        this.m_mousePressed = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.m_mousePressed) {
            this.SendKey(this.m_keyId);
        }
    }

    private void SendKey(int n) {
        if (!this.m_instrument.isConnected()) {
            return;
        }
        String string = "KEYY " + n;
        this.m_instrument.sendCmd(string);
    }
}

